/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cherishedworlds.client.favorites;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionList;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiScreenEvent;
import top.theillusivec4.cherishedworlds.CherishedWorldsMod;
import top.theillusivec4.cherishedworlds.client.favorites.FavoritesList;
import top.theillusivec4.cherishedworlds.client.favorites.IFavoritesManager;
import top.theillusivec4.cherishedworlds.mixin.core.WorldSelectionListEntryAccessor;
import top.theillusivec4.cherishedworlds.mixin.core.WorldSelectionScreenAccessor;

public class FavoriteWorlds
implements IFavoritesManager<WorldSelectionScreen> {
    @Override
    public void init(WorldSelectionScreen screen) {
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getSelectionList();
        if (selectionList != null) {
            TextFieldWidget textField = accessor.getSearchField();
            if (textField != null) {
                textField.func_212954_a(s -> FavoriteWorlds.refreshList(selectionList, () -> s));
            }
            FavoriteWorlds.refreshList(selectionList);
        }
    }

    @Override
    public void draw(GuiScreenEvent.DrawScreenEvent.Post evt, WorldSelectionScreen screen) {
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getSelectionList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.func_231039_at__().size(); ++i) {
                WorldSelectionListEntryAccessor entryAccessor;
                WorldSummary summary;
                WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.func_231039_at__().get(i);
                if (entry == null || (summary = (entryAccessor = (WorldSelectionListEntryAccessor)entry).getWorldSummary()) == null) continue;
                boolean isFavorite = FavoritesList.contains(summary.func_75786_a());
                this.drawIcon(evt, (Screen)screen, i, isFavorite, selectionList.getTop(), selectionList.func_230966_l_(), selectionList.getBottom());
            }
        }
    }

    @Override
    public void click(GuiScreenEvent.MouseClickedEvent.Pre evt, WorldSelectionScreen screen) {
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getSelectionList();
        if (selectionList != null) {
            for (int i = 0; i < selectionList.func_231039_at__().size(); ++i) {
                WorldSelectionListEntryAccessor entryAccessor;
                WorldSummary summary;
                WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.func_231039_at__().get(i);
                if (entry == null || (summary = (entryAccessor = (WorldSelectionListEntryAccessor)entry).getWorldSummary()) == null) continue;
                boolean isFavorite = FavoritesList.contains(summary.func_75786_a());
                int top = (int)((double)(selectionList.getTop() + 15 + 36 * i) - selectionList.func_230966_l_());
                int x = evt.getGui().field_230708_k_ / 2 - this.getOffset();
                double mouseX = evt.getMouseX();
                double mouseY = evt.getMouseY();
                if (!(mouseY >= (double)top) || !(mouseY <= (double)(top + 9)) || !(mouseX >= (double)x) || !(mouseX <= (double)(x + 9))) continue;
                String s = summary.func_75786_a();
                if (isFavorite) {
                    FavoritesList.remove(s);
                } else {
                    FavoritesList.add(s);
                }
                FavoritesList.save();
                FavoriteWorlds.refreshList(selectionList);
                return;
            }
        }
    }

    @Override
    public void clicked(WorldSelectionScreen screen) {
        WorldSelectionList.Entry entry;
        WorldSelectionScreenAccessor accessor = (WorldSelectionScreenAccessor)screen;
        WorldSelectionList selectionList = accessor.getSelectionList();
        if (selectionList != null && (entry = (WorldSelectionList.Entry)selectionList.func_230958_g_()) != null) {
            WorldSelectionListEntryAccessor entryAccessor = (WorldSelectionListEntryAccessor)entry;
            WorldSummary summary = entryAccessor.getWorldSummary();
            Button deleteButton = accessor.getDeleteButton();
            if (deleteButton != null && summary != null) {
                FavoriteWorlds.disableDeletion(summary, deleteButton);
            }
        }
    }

    @Override
    public int getOffset() {
        return 148;
    }

    private static void refreshList(WorldSelectionList listWorldSelection) {
        FavoriteWorlds.refreshList(listWorldSelection, null);
    }

    private static void refreshList(WorldSelectionList listWorldSelection, Supplier<String> supplier) {
        List list;
        Minecraft mc = Minecraft.func_71410_x();
        SaveFormat saveformat = mc.func_71359_d();
        try {
            list = saveformat.func_75799_b();
        }
        catch (AnvilConverterException anvilconverterexception) {
            CherishedWorldsMod.LOGGER.error("Couldn't load level list", (Throwable)anvilconverterexception);
            mc.func_147108_a((Screen)new ErrorScreen((ITextComponent)new TranslationTextComponent("selectWorld.unable_to_load"), (ITextComponent)new StringTextComponent(anvilconverterexception.getMessage())));
            return;
        }
        List entries = listWorldSelection.func_231039_at__();
        entries.clear();
        ListIterator iter = list.listIterator();
        ArrayList<WorldSummary> favorites = new ArrayList<WorldSummary>();
        while (iter.hasNext()) {
            WorldSummary summ = (WorldSummary)iter.next();
            if (!FavoritesList.contains(summ.func_75786_a())) continue;
            favorites.add(summ);
            iter.remove();
        }
        Collections.sort(favorites);
        Collections.sort(list);
        String s = supplier == null ? "" : supplier.get().toLowerCase(Locale.ROOT);
        for (WorldSummary worldsummary : favorites) {
            if (!s.isEmpty() && !worldsummary.func_75788_b().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.func_75786_a().toLowerCase(Locale.ROOT).contains(s)) continue;
            WorldSelectionList worldSelectionList = listWorldSelection;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.Entry(worldSelectionList, listWorldSelection, worldsummary));
        }
        for (WorldSummary worldsummary : list) {
            if (!s.isEmpty() && !worldsummary.func_75788_b().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.func_75786_a().toLowerCase(Locale.ROOT).contains(s)) continue;
            WorldSelectionList worldSelectionList = listWorldSelection;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.Entry(worldSelectionList, listWorldSelection, worldsummary));
        }
        WorldSelectionList.Entry entry = (WorldSelectionList.Entry)listWorldSelection.func_230958_g_();
        if (entry != null) {
            WorldSelectionListEntryAccessor entryAccessor = (WorldSelectionListEntryAccessor)entry;
            WorldSummary summary = entryAccessor.getWorldSummary();
            Button deleteButton = ((WorldSelectionScreenAccessor)listWorldSelection.func_186796_g()).getDeleteButton();
            if (deleteButton != null && summary != null) {
                FavoriteWorlds.disableDeletion(summary, deleteButton);
            }
        }
    }

    private static void disableDeletion(@Nonnull WorldSummary summary, Button deleteButton) {
        deleteButton.field_230693_o_ = !FavoritesList.contains(summary.func_75786_a());
    }
}

